/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Audio.AudioPlayer;
import Entity.MenuOption;
import Entity.Mouse;
import Entity.PlayerSave;
import GameState.GameState;
import GameState.GameStateManager;
import Handlers.Keys;
import Handlers.Options;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

public class GameOverState
extends GameState {
    private int currentChoice = 0;
    private String[] options = new String[]{"Retry", "Title Menu"};
    private Font font;
    private MenuOption mo;
    private Mouse mouse;

    public GameOverState(GameStateManager gsm) {
        this.gsm = gsm;
        try {
            this.font = new Font("Arial", 0, 22);
            this.mo = new MenuOption(this.options, gsm.regFont, 400, 340, 0, 35);
            this.mouse = new Mouse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void update() {
        this.handleInput();
        this.mo.update(this.mouse);
        this.mouse.update();
    }

    @Override
    public void draw(Graphics2D g) {
        g.setFont(this.font);
        g.setColor(Color.white);
        this.gsm.drawCenteredString("Game Over!", 800, 50, g);
        this.gsm.drawCenteredString("Your Score : " + PlayerSave.getScore(), 800, 120, g);
        PlayerSave.drawHighScore(g, this.font);
        g.setFont(this.gsm.regFont);
        if (Options.getOption(5)) {
            this.mo.draw(g);
            this.mouse.draw(g);
        } else {
            int i = 0;
            while (i < this.options.length) {
                if (i == this.currentChoice) {
                    g.setColor(Color.YELLOW);
                } else {
                    g.setColor(Color.WHITE);
                }
                this.gsm.drawCenteredString(this.options[i], 800, 680 + i * 70, g);
                ++i;
            }
        }
    }

    private void select(int currentChoice) {
        if (currentChoice == 0) {
            this.gsm.setState(1);
        }
        if (currentChoice == 1) {
            this.gsm.setState(0);
            AudioPlayer.loop("introMusic", 0.0);
        }
    }

    @Override
    public void handleInput() {
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            System.exit(0);
        }
        if (Options.getOption(5)) {
            if (Keys.isMousePressed(Keys.LEFTCLICK)) {
                this.select(this.mo.getChoice());
            }
        } else {
            if (Keys.isKeyPressed(Keys.ENTER)) {
                this.select(this.currentChoice);
            }
            if (Keys.isKeyPressed(Keys.UP)) {
                this.currentChoice = this.currentChoice > 0 ? --this.currentChoice : this.options.length - 1;
            }
            if (Keys.isKeyPressed(Keys.DOWN)) {
                this.currentChoice = this.currentChoice < this.options.length - 1 ? ++this.currentChoice : 0;
            }
        }
    }
}

